/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.tests.dao;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IDao;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.ModelVO;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ModelDAOTest
extends TestCase {
    private IDao dao;
    private boolean bInitialize;

    public ModelDAOTest(String string) {
        super(string);
    }

    protected void setUp() {
        try {
            System.setProperty(XMLDAOFactory.dataFileEnv, "." + System.getProperty("file.separator") + "Properties.props");
            this.dao = XMLDAOFactory.getModelDAO();
            this.bInitialize = true;
        }
        catch (Exception exception) {
            this.bInitialize = false;
        }
    }

    public void insertTest() {
        boolean bl = false;
        ModelVO modelVO = new ModelVO();
        modelVO.setManufacturer("Test Manufacturer");
        modelVO.setDescription("Test Description");
        modelVO.setLastUpdate(System.currentTimeMillis());
        modelVO.setName("test name");
        modelVO.setNumber("1");
        modelVO.setId("ID111");
        modelVO.setNew();
        try {
            this.dao.add(modelVO);
            this.dao.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        ModelDAOTest.assertEquals((boolean)bl, (boolean)false);
    }

    public void readAllTest() {
        boolean bl = false;
        try {
            IPersistable[] iPersistableArray = this.dao.readAll();
            System.out.println(iPersistableArray.length);
            if (iPersistableArray.length > 0) {
                for (int i = 0; i < iPersistableArray.length; ++i) {
                    IPersistable iPersistable = iPersistableArray[i];
                    System.out.println(iPersistable.getId());
                }
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        ModelDAOTest.assertEquals((boolean)bl, (boolean)false);
    }

    public void readTest() {
        boolean bl = false;
        String string = "ID1";
        try {
            IPersistable iPersistable = this.dao.read(string);
            bl = !iPersistable.getId().equals(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        ModelDAOTest.assertEquals((boolean)bl, (boolean)false);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new ModelDAOTest("readTest"));
        testSuite.addTest((Test)new ModelDAOTest("readAllTest"));
        testSuite.addTest((Test)new ModelDAOTest("insertTest"));
        return testSuite;
    }
}

